/**
* \file: osgencoder.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Abstract base class for encoders for OSG
*
* \component: osgStream
*
* \author: Jens Georg <jgeorg@de.adit-jv.com>
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
***********************************************************************/

#ifndef OSG_GSTPIPE_H
#define OSG_GSTPIPE_H

#include <gst/app/gstappsrc.h>
#include <queue>

namespace osgGstpipeline {

class gstpipeline
{

public:

    class appsrcTraits {
    public:
        appsrcTraits() :
            width(256),
            height(256),
            depth(32),
            endianness(1234),
            red_mask(0xF800),
            green_mask(0x07E0),
            blue_mask(0x001F),
            alpha_mask(0),
            fpsNum(25),
            fpsDem(1)
            {}

        uint width;
        uint height;
        uint depth;
        uint endianness;
        uint red_mask;
        uint green_mask;
        uint blue_mask;
        uint alpha_mask;

        uint fpsNum;
        uint fpsDem;
    };

    bool blockMode;
    bool use_oldbuffer;

    gstpipeline(gstpipeline::appsrcTraits &);
    ~gstpipeline();
    void play();
    void start();
    static void* run(void *);
    void stop();
    void close();

    static void buffercallback(void *user_data, void *buffer);
    void set_stream_size( uint width, uint height);

private:

    GMainContext *context;
    GMainLoop *loop;
    ulong callbackId;
    bool playing;
    pthread_mutex_t lock;

    pthread_t thread;
    appsrcTraits appsrc_traits;

    GstElement *pipeline;
    GstElement *appsrc;
    GstBus *bus;

    GstBuffer *currentBuffer;
    GstBuffer *oldBuffer;
    bool nodata_to_push;

    void create(gstpipeline::appsrcTraits &appsrc_traits);
    bool ready() const;
    void push_appsrc(GstBuffer *buffer);
    void setAppsrcTraits(gstpipeline::appsrcTraits &traits);
    gstpipeline::appsrcTraits &getAppsrcTraits();
    GstCaps* create_appsrc_caps();
    void requestTimingProbe (GstElement *element, const char *inTag, const char *outTag);

    /* Callback functions */
    void onNeedData(GstAppSrc *);
    gboolean onBusSignal(GstBus *, GstMessage *message);
    void GstBufferCallBack(void *buffer);

    /* GObject signal callbacks */
    static gboolean bus_signal(GstBus *bus, GstMessage *message, gpointer user_data);
    static void on_need_data(GstAppSrc *, guint length, gpointer user_data);
    static gboolean on_buffer_probe (GstPad *pad, GstMiniObject *data, gpointer user_data);


    /*For synch between on need data and callback*/
    pthread_mutex_t sync_lock = PTHREAD_MUTEX_INITIALIZER;
    pthread_cond_t sync_cond = PTHREAD_COND_INITIALIZER;
    struct sync_parameters
    {
        sync_parameters() : curr_buffer(NULL){}
        GstBuffer  *curr_buffer;
    }sync_params;
    std::queue<sync_parameters> bufferqueue;
    bool stop_push;
};
} // osgGstpipeline
#endif // OSG_GSTPIPE_H
